;;; - ------------------------------------------------------------------------------ - ;
;;; -                 T O O L - K_EQUAL                                              - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Beschreibung :  Objekte mit gleichen Daten finden                              - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Befehle      :  k_equal                                                        - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - letzte nderung am : 23.10.2023                                                - ;
;;; -              durch : Andreas Kraus                                             - ;
;;; - ------------------------------------------------------------------------------ - ;

(vl-load-com)
(DEFUN COMPARE (E0 E1 /)
  (COND	((> (CAR E0) (CAR E1)) 1)
	((< (CAR E0) (CAR E1)) -1)
	((QUOTE T) 0)
  )
)
(DEFUN GATHER (LST LEN)
  (COND	((NULL LST) nil)
	((> (LENGTH LST) LEN)
	 (CONS (N-CAR LEN LST) (GATHER (N-CDR LEN LST) LEN))
	)
	((QUOTE SONST) (LIST LST))
  )
)
(DEFUN K_->ENT_NAME (NAME)
  (COND	((= (TYPE NAME) (QUOTE ENAME)) NAME)
	((= (TYPE NAME) (QUOTE VLA-OBJECT))
	 (vlax-vla-object->ename NAME)
	)
	((= (TYPE NAME) (QUOTE STR)) (HANDENT NAME))
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC -1 NAME))
	 (CDR (ASSOC -1 NAME))
	)
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC 5 NAME))
	 (HANDENT (CDR (ASSOC 5 NAME)))
	)
  )
)
(DEFUN K_->OBJ_NAME (NAME)
  (COND	((= (TYPE NAME) (QUOTE ENAME))
	 (vlax-ename->vla-object NAME)
	)
	((= (TYPE NAME) (QUOTE VLA-OBJECT)) NAME)
	((= (TYPE NAME) (QUOTE STR))
	 (vlax-ename->vla-object (HANDENT NAME))
	)
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC -1 NAME))
	 (vlax-ename->vla-object (CDR (ASSOC -1 NAME)))
	)
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC 5 NAME))
	 (vlax-ename->vla-object (HANDENT (CDR (ASSOC 5 NAME))))
	)
  )
)
(DEFUN K_COUNTER_DIALOG	(TODO TXT1 TXT2)
  (DEFUN K_COUNTER_DIALOG_NEU nil
    (DONE_DIALOG)
    (NEW_DIALOG "k_counter_dialog" K_COUNTER_DLG)
    (SETQ K_COUNTER_DIALOG_N 0)
  )
  (COND	((AND (= (TYPE TODO) (QUOTE STR)) (= (STRCASE TODO) "START"))
	 (SETQ K_COUNTER_DLG
		(LOAD_DIALOG "k_main.dcl")
	       K_COUNTER_DIALOG_N 0
	       K_COUNTER_DIALOG_TITEL TXT1
	 )
	 (COND ((AND TXT2 (= (TYPE TXT1) (QUOTE INT)))
		(SETQ K_COUNTER_DIALOG_X TXT2)
	       )
	       ((AND TXT2 (= (TYPE TXT1) (QUOTE STR)))
		(SETQ K_COUNTER_DIALOG_T TXT2)
	       )
	       (T (SETQ K_COUNTER_DIALOG_X nil))
	 )
	 (IF (NOT (NEW_DIALOG "k_counter_dialog" K_COUNTER_DLG))
	   (EXIT)
	 )
	 (IF K_COUNTER_DIALOG_TITEL
	   (SET_TILE "titel"
		     (VL-PRINC-TO-STRING K_COUNTER_DIALOG_TITEL)
	   )
	 )
	)
	((AND (= (TYPE TODO) (QUOTE STR)) (= (STRCASE TODO) "END"))
	 (DONE_DIALOG)
	 (IF K_COUNTER_DLG
	   (UNLOAD_DIALOG K_COUNTER_DLG)
	 )
	 (SETQ K_COUNTER_DIALOG_N nil
	       K_COUNTER_DLG nil
	 )
	)
	((AND (= (TYPE TODO) (QUOTE STR)) (= (STRCASE TODO) "SHOW"))
	 (SETQ K_COUNTER_DIALOG_N (1+ K_COUNTER_DIALOG_N))
	 (IF (AND K_COUNTER_DIALOG_X
		  (>= K_COUNTER_DIALOG_N K_COUNTER_DIALOG_X)
	     )
	   (K_COUNTER_DIALOG_NEU)
	 )
	 (SET_TILE "text1" (VL-PRINC-TO-STRING TXT1))
	 (SET_TILE "text2" (VL-PRINC-TO-STRING TXT2))
	)
	(T nil)
  )
)
(DEFUN K_DEL-NTH (LISTE N / DUMMY_LIST)
  (REPEAT N
    (SETQ DUMMY_LIST (CONS (CAR LISTE) DUMMY_LIST)
	  LISTE	     (CDR LISTE)
    )
  )
  (APPEND (REVERSE DUMMY_LIST) (CDR LISTE))
)
(DEFUN K_ENTLIST->SATZ (ENT_LIST / N SATZ ENT_NAME)
  (IF (LISTP ENT_LIST)
    (PROGN (SETQ SATZ (SSADD))
	   (MAPCAR (QUOTE
		     (LAMBDA (ENT_NAME)
		       (COND ((AND (= (TYPE ENT_NAME) (QUOTE VLA-OBJECT))
				   (K_->ENT_NAME ENT_NAME)
			      )
			      (SETQ SATZ (SSADD (vlax-vla-object->ename ENT_NAME) SATZ))
			     )
			     ((AND (= (TYPE ENT_NAME) (QUOTE ENAME))
				   (K_->OBJ_NAME ENT_NAME)
			      )
			      (SETQ SATZ (SSADD ENT_NAME SATZ))
			     )
			     ((= (TYPE ENT_NAME) (QUOTE STR))
			      (IF (HANDENT ENT_NAME)
				(SETQ SATZ (SSADD (HANDENT ENT_NAME) SATZ))
			      )
			     )
		       )
		     )
		   )
		   ENT_LIST
	   )
    )
  )
  SATZ
)
(DEFUN K_GET-TEXTSTRING	(ENT_NAME / ENT_DATA)
  (SETQ	ENT_DATA (COND ((= (TYPE ENT_NAME) (QUOTE VLA-OBJECT))
			(ENTGET (vlax-vla-object->ename ENT_NAME))
		       )
		       ((= (TYPE ENT_NAME) (QUOTE ENAME)) (ENTGET ENT_NAME))
		       ((= (TYPE ENT_NAME) (QUOTE LIST)) ENT_NAME)
		 )
  )
  (WHILE (> (LENGTH (K_GET_ASSOC ENT_DATA 1)) 1)
    (SETQ ENT_DATA (K_DEL-NTH ENT_DATA
			      (VL-POSITION (ASSOC 1 ENT_DATA) ENT_DATA)
		   )
    )
  )
  (COND	((= (CDR (ASSOC 0 ENT_DATA)) "ATTDEF")
	 (APPLY	(QUOTE STRCAT)
		(MAPCAR (QUOTE CDR) (K_GET_ASSOC ENT_DATA (QUOTE (1 3))))
	 )
	)
	((MEMBER (CDR (ASSOC 0 ENT_DATA))
		 (QUOTE ("TEXT" "MTEXT" "ATTRIB"))
	 )
	 (APPLY	(QUOTE STRCAT)
		(MAPCAR (QUOTE CDR) (K_GET_ASSOC ENT_DATA (QUOTE (1 3))))
	 )
	)
	((MEMBER (CDR (ASSOC 0 ENT_DATA)) (QUOTE ("MULTILEADER")))
	 (vla-get-TextString
	   (vlax-ename->vla-object (CDR (ASSOC -1 ENT_DATA)))
	 )
	)
	(T nil)
  )
)
(DEFUN K_GET_ASSOC (LISTE GRUPPE)
  (IF (/= (TYPE GRUPPE) (QUOTE LIST))
    (SETQ GRUPPE (LIST GRUPPE))
  )
  (VL-REMOVE-IF-NOT
    (QUOTE (LAMBDA (DATA) (MEMBER (CAR DATA) GRUPPE)))
    LISTE
  )
)
(DEFUN K_GET_DATA (OBJ_NAMEN BEZ APP_LIST ART)
  (DEFUN K_GET_DATA_WORK (OBJ_NAME / ATT_LIST DAT DATA DATA_LIST DYN_LIST ML_LIST OBJ PROP XDATA XTYPE)
    (IF	OBJ_NAME
      (PROGN (IF (= (TYPE APP_LIST) (QUOTE STR))
	       (SETQ APP_LIST (LIST APP_LIST))
	     )
	     (IF (= (TYPE ART) (QUOTE STR))
	       (SETQ ART (LIST ART))
	     )
	     (IF (= (TYPE OBJ_NAME) (QUOTE ENAME))
	       (SETQ OBJ_NAME (vlax-ename->vla-object OBJ_NAME))
	     )
	     (IF (AND (OR (NULL ART) (MEMBER "*" ART) (MEMBER "ATT" ART))
		      (L-CONJUNCTION
			(IF (LISTP BEZ)
			  BEZ
			  (LIST BEZ)
			)
			(LIST "*" "ML-Beschreibung")
		      )
		      (= (vla-get-ObjectName OBJ_NAME) "AcDbMline")
		 )
	       (SETQ ML_LIST (LIST
			       (LIST "ML-Beschreibung"
				     (CDR
				       (ASSOC 3
					      (DICTSEARCH
						(CDR
						  (ASSOC -1 (DICTSEARCH (NAMEDOBJDICT) "ACAD_MLINESTYLE"))
						)
						(vla-get-StyleName OBJ_NAME)
					      )
				       )
				     )
			       )
			     )
	       )
	     )
	     (IF (AND (OR (NULL ART) (MEMBER "ATT" (MAPCAR (QUOTE STRCASE) ART)))
		      (vlax-property-available-p OBJ_NAME "hasattributes")
		      (= (vla-get-HasAttributes OBJ_NAME) :vlax-true)
		      (NOT
			(MINUSP	(vlax-safearray-get-u-bound
				  (vlax-variant-value (vla-GetAttributes OBJ_NAME))
				  1
				)
			)
		      )
		 )
	       (SETQ ATT_LIST (MAPCAR (QUOTE
					(LAMBDA	(OBJ)
					  (LIST (vla-get-TagString OBJ) (K_GET-TEXTSTRING OBJ))
					)
				      )
				      (vlax-invoke OBJ_NAME (QUOTE GETATTRIBUTES))
			      )
	       )
	     )
	     (IF (AND (OR (NULL ART) (MEMBER "DYN" (MAPCAR (QUOTE STRCASE) ART)))
		      (vlax-property-available-p OBJ_NAME "isdynamicblock")
		      (= (vla-get-IsDynamicBlock OBJ_NAME) :vlax-true)
		 )
	       (SETQ DYN_LIST (VL-REMOVE (QUOTE nil)
					 (MAPCAR (QUOTE	(LAMBDA	(PROP)
							  (IF (= (vla-get-Show PROP) :vlax-true)
							    (LIST (vla-get-PropertyName PROP)
								  (vlax-variant-value (vla-get-Value PROP))
							    )
							  )
							)
						 )
						 (IF (VL-CATCH-ALL-ERROR-P
						       (VL-CATCH-ALL-APPLY
							 (QUOTE vlax-invoke)
							 (LIST OBJ_NAME (QUOTE GETDYNAMICBLOCKPROPERTIES))
						       )
						     )
						   nil
						   (vlax-invoke OBJ_NAME (QUOTE GETDYNAMICBLOCKPROPERTIES))
						 )
					 )
			      )
	       )
	     )
	     (IF (AND (OR (NULL ART) (MEMBER "EED" (MAPCAR (QUOTE STRCASE) ART)))
		      (MEMBER "*" APP_LIST)
		 )
	       (VLAX-FOR APP (vla-get-RegisteredApplications (vla-get-Document OBJ_NAME))
		 (IF (AND (NOT (VL-CATCH-ALL-ERROR-P
				 (VL-CATCH-ALL-APPLY
				   (QUOTE vla-GetXData)
				   (LIST OBJ_NAME
					 (vla-get-Name APP)
					 (QUOTE XTYPE)
					 (QUOTE XDATA)
				   )
				 )
			       )
			  )
			  XTYPE
			  XDATA
		     )
		   (PROGN (vlax-safearray->list XTYPE)
			  (SETQ	DATA_LIST (APPEND DATA_LIST
						  (VL-REMOVE-IF-NOT
						    (QUOTE (LAMBDA (DATA) (= (TYPE (CAR DATA)) (QUOTE STR))))
						    (GATHER (CDR (MAPCAR (QUOTE vlax-variant-value)
									 (vlax-safearray->list XDATA)
								 )
							    )
							    2
						    )
						  )
					  )
			  )
		   )
		 )
	       )
	       (FOREACH	APP APP_LIST
		 (IF (AND (NOT (VL-CATCH-ALL-ERROR-P
				 (VL-CATCH-ALL-APPLY
				   (QUOTE vla-GetXData)
				   (LIST OBJ_NAME APP (QUOTE XTYPE) (QUOTE XDATA))
				 )
			       )
			  )
			  XTYPE
			  XDATA
		     )
		   (PROGN (vlax-safearray->list XTYPE)
			  (SETQ	DATA_LIST (APPEND DATA_LIST
						  (VL-REMOVE-IF-NOT
						    (QUOTE (LAMBDA (DATA) (= (TYPE (CAR DATA)) (QUOTE STR))))
						    (GATHER (CDR (MAPCAR (QUOTE vlax-variant-value)
									 (vlax-safearray->list XDATA)
								 )
							    )
							    2
						    )
						  )
					  )
			  )
		   )
		 )
	       )
	     )
	     (COND ((= (TYPE BEZ) (QUOTE STR))
		    (IF	(= BEZ "*")
		      (PROGN
			(SETQ DATA (APPEND ML_LIST ATT_LIST DATA_LIST DYN_LIST))
		      )
		      (PROGN
			(SETQ DATA (COND ((vlax-property-available-p OBJ_NAME BEZ)
					  (IF (VL-CATCH-ALL-ERROR-P
						(SETQ DATA (VL-CATCH-ALL-APPLY
							     (QUOTE getpropertyvalue)
							     (LIST (K_->ENT_NAME OBJ_NAME) BEZ)
							   )
						)
					      )
					    (SETQ DATA (EVAL (LIST (READ (STRCAT "vla-get-" BEZ)) OBJ_NAME)))
					    DATA
					  )
					 )
					 ((ASSOC BEZ ML_LIST)
					  (SETQ DATA (NTH 1 (ASSOC BEZ ML_LIST)))
					 )
					 ((ASSOC (STRCASE BEZ)
						 (MAPCAR (QUOTE (LAMBDA (DAT) (LIST (STRCASE (CAR DAT)) (CADR DAT))))
							 ML_LIST
						 )
					  )
					  (SETQ	DATA (NTH 1
							  (ASSOC (STRCASE BEZ)
								 (MAPCAR (QUOTE (LAMBDA (DAT) (LIST (STRCASE (CAR DAT)) (CADR DAT))))
									 ML_LIST
								 )
							  )
						     )
					  )
					 )
					 ((ASSOC BEZ DYN_LIST)
					  (SETQ DATA (NTH 1 (ASSOC BEZ DYN_LIST)))
					 )
					 ((ASSOC (STRCASE BEZ)
						 (MAPCAR (QUOTE (LAMBDA (DAT) (LIST (STRCASE (CAR DAT)) (CADR DAT))))
							 DYN_LIST
						 )
					  )
					  (SETQ	DATA (NTH 1
							  (ASSOC (STRCASE BEZ)
								 (MAPCAR (QUOTE (LAMBDA (DAT) (LIST (STRCASE (CAR DAT)) (CADR DAT))))
									 DYN_LIST
								 )
							  )
						     )
					  )
					 )
					 ((ASSOC BEZ ATT_LIST)
					  (SETQ DATA (NTH 1 (ASSOC BEZ ATT_LIST)))
					 )
					 ((ASSOC (STRCASE BEZ)
						 (MAPCAR (QUOTE (LAMBDA (DAT) (LIST (STRCASE (CAR DAT)) (CADR DAT))))
							 ATT_LIST
						 )
					  )
					  (SETQ	DATA (NTH 1
							  (ASSOC (STRCASE BEZ)
								 (MAPCAR (QUOTE (LAMBDA (DAT) (LIST (STRCASE (CAR DAT)) (CADR DAT))))
									 ATT_LIST
								 )
							  )
						     )
					  )
					 )
					 ((ASSOC BEZ DATA_LIST)
					  (SETQ DATA (NTH 1 (ASSOC BEZ DATA_LIST)))
					 )
					 ((ASSOC (STRCASE BEZ)
						 (MAPCAR (QUOTE (LAMBDA (DAT) (LIST (STRCASE (CAR DAT)) (CADR DAT))))
							 DATA_LIST
						 )
					  )
					  (SETQ	DATA (NTH 1
							  (ASSOC (STRCASE BEZ)
								 (MAPCAR (QUOTE (LAMBDA (DAT) (LIST (STRCASE (CAR DAT)) (CADR DAT))))
									 DATA_LIST
								 )
							  )
						     )
					  )
					 )
				   )
			)
		      )
		    )
		   )
		   ((= (TYPE BEZ) (QUOTE LIST))
		    (SETQ DATA (MAPCAR (QUOTE
					 (LAMBDA (BEZ / DATA)
					   (COND ((vlax-property-available-p OBJ_NAME BEZ)
						  (IF (VL-CATCH-ALL-ERROR-P
							(SETQ DATA (VL-CATCH-ALL-APPLY
								     (QUOTE getpropertyvalue)
								     (LIST (K_->ENT_NAME OBJ_NAME) BEZ)
								   )
							)
						      )
						    (SETQ DATA (EVAL (LIST (READ (STRCAT "vla-get-" BEZ)) OBJ_NAME)))
						  )
						 )
						 ((ASSOC BEZ DYN_LIST)
						  (SETQ DATA (NTH 1 (ASSOC BEZ DYN_LIST)))
						 )
						 ((ASSOC (STRCASE BEZ)
							 (MAPCAR (QUOTE (LAMBDA (DAT) (LIST (STRCASE (CAR DAT)) (CADR DAT))))
								 DYN_LIST
							 )
						  )
						  (SETQ	DATA (NTH 1
								  (ASSOC (STRCASE BEZ)
									 (MAPCAR (QUOTE (LAMBDA (DAT) (LIST (STRCASE (CAR DAT)) (CADR DAT))))
										 DYN_LIST
									 )
								  )
							     )
						  )
						 )
						 ((ASSOC BEZ ATT_LIST)
						  (SETQ DATA (NTH 1 (ASSOC BEZ ATT_LIST)))
						 )
						 ((ASSOC (STRCASE BEZ)
							 (MAPCAR (QUOTE (LAMBDA (DAT) (LIST (STRCASE (CAR DAT)) (CADR DAT))))
								 ATT_LIST
							 )
						  )
						  (SETQ	DATA (NTH 1
								  (ASSOC (STRCASE BEZ)
									 (MAPCAR (QUOTE (LAMBDA (DAT) (LIST (STRCASE (CAR DAT)) (CADR DAT))))
										 ATT_LIST
									 )
								  )
							     )
						  )
						 )
						 ((ASSOC BEZ DATA_LIST)
						  (SETQ DATA (NTH 1 (ASSOC BEZ DATA_LIST)))
						 )
						 ((ASSOC (STRCASE BEZ)
							 (MAPCAR (QUOTE (LAMBDA (DAT) (LIST (STRCASE (CAR DAT)) (CADR DAT))))
								 DATA_LIST
							 )
						  )
						  (SETQ	DATA (NTH 1
								  (ASSOC (STRCASE BEZ)
									 (MAPCAR (QUOTE (LAMBDA (DAT) (LIST (STRCASE (CAR DAT)) (CADR DAT))))
										 DATA_LIST
									 )
								  )
							     )
						  )
						 )
					   )
					   (LIST BEZ DATA)
					 )
				       )
				       BEZ
			       )
		    )
		   )
	     )
      )
      (SETQ DATA nil)
    )
    (FOREACH V (QUOTE (OBJ_NAME	ATT_LIST DAT DATA DATA_LIST DYN_LIST ML_LIST OBJ PROP XDATA XTYPE)
	       )
      (SETQ V nil)
    )
    DATA
  )
  (COND	((LISTP OBJ_NAMEN)
	 (MAPCAR (QUOTE K_GET_DATA_WORK) OBJ_NAMEN)
	)
	((= (TYPE OBJ_NAMEN) (QUOTE PICKSET))
	 (MAPCAR (QUOTE K_GET_DATA_WORK) (K_SATZ->ENTLIST OBJ_NAMEN))
	)
	(T (K_GET_DATA_WORK OBJ_NAMEN))
  )
)
(DEFUN K_GET_MERKLISTE (NAME / WERT)
  (IF (ASSOC NAME K_MERKLISTE)
    (SETQ WERT (NTH 1 (ASSOC NAME K_MERKLISTE)))
  )
  WERT
)
(DEFUN K_IS (WERT)
  (COND	((= WERT :vlax-false) nil)
	((= WERT :vlax-true) T)
	((= WERT nil) nil)
	((= WERT T) T)
	((= WERT 1) T)
	((= WERT 0) nil)
	((= WERT "1") T)
	((= WERT "0") nil)
	((= (STRCASE WERT) "JA") T)
	((= (STRCASE WERT) "NEIN") nil)
  )
)
(DEFUN K_PUT_MERKLISTE (NAME WERT)
  (IF (ASSOC NAME K_MERKLISTE)
    (SETQ K_MERKLISTE
	   (SUBST (LIST NAME WERT)
		  (ASSOC NAME K_MERKLISTE)
		  K_MERKLISTE
	   )
    )
    (SETQ K_MERKLISTE (CONS (LIST NAME WERT) K_MERKLISTE))
  )
  (PRINC)
)
(DEFUN K_SATZ->ENTLIST (SATZ)
  (IF (= (TYPE SATZ) (QUOTE PICKSET))
    (VL-REMOVE-IF-NOT
      (QUOTE (LAMBDA (DUMMY) (= (TYPE DUMMY) (QUOTE ENAME))))
      (MAPCAR (QUOTE CADR) (SSNAMEX SATZ))
    )
  )
)
(DEFUN L-CONJUNCTION (L0 L1 / CMP L2)
  (SETQ L0 (VL-SORT (MAKE-SORTABLE L0) (QUOTE _<)))
  (SETQ L1 (VL-SORT (MAKE-SORTABLE L1) (QUOTE _<)))
  (WHILE (AND L0 L1)
    (SETQ CMP (COMPARE (CAR L0) (CAR L1)))
    (COND ((= CMP -1) (SETQ L0 (CDR L0)))
	  ((= CMP 1) (SETQ L1 (CDR L1)))
	  ((QUOTE T)
	   (SETQ L2 (CONS (CDR (CAR L0)) L2)
		 L0 (CDR L0)
		 L1 (CDR L1)
	   )
	  )
    )
  )
  L2
)
(DEFUN MAKE-SORTABLE (L /)
  (MAPCAR (QUOTE (LAMBDA (E /) (CONS (VL-PRIN1-TO-STRING E) E)))
	  L
  )
)
(DEFUN N-CAR (N LST / RES)
  (REPEAT (MIN N (LENGTH LST))
    (SETQ RES (CONS (CAR LST) RES)
	  LST (CDR LST)
    )
  )
  (REVERSE RES)
)
(DEFUN N-CDR (N LST) (REPEAT N (SETQ LST (CDR LST))))
(DEFUN _< (E0 E1 /) (< (CAR E0) (CAR E1)))

(defun c:k_equal (/		ABWAHL_LIST   APP_NAME	    ART		  ASSOC_OBJECTS	ATT_BEZ_LIST  ATT_FILTER_LIST		  ATT_INH_LIST	AUSWAHL_LIST
		  BLUE		BOOKNAME      COLOR	    COLORNAME	  DATA		DATA_LIST1    DATA_LIST2    DUMMY	  DUMMY_LIST	ENT_DATA
		  ENT_LIST	ENT_NAME      FARBFILTER    FARBNUMMER	  FILTER	GREEN	      LINIENTYP	    ML-BESCHREIBUNG		N
		  k_equal_ID	NR	      OBJ_ART	    OK		  RED		SATZ	      VLA_FILTER_LIST		  WERT
		 )
;;; Objektfilter
  (defun end_k_equal (wert)
    (setq ok wert)
    (setq assoc_objects (get_tile "assoc"))
    (done_dialog)
  )

  (defun k_equal_raus ()
    (setq nr (atoi (get_tile "auswahl")))
    (setq dummy_list (list))
    (setq n 0)
    (foreach
	      data
		  data_list1
      (if (/= n nr)
	(setq dummy_list (cons data dummy_list))
	(setq data_list2 (cons data data_list2))
      )
      (setq n (1+ n))
    )
    (setq data_list1 (reverse dummy_list))
    (k_equal_auswahl)
    (k_equal_abwahl)
    (if	data_list1
      (progn
	(setq nr (min nr (1- (length data_list1))))
	(set_tile "auswahl" (itoa nr))
      )
    )
  )

  (defun k_equal_rein ()
    (setq nr (atoi (get_tile "abwahl")))
    (setq dummy_list (list))
    (setq n 0)
    (foreach
	      data
		  data_list2
      (if (/= n nr)
	(setq dummy_list (cons data dummy_list))
	(setq data_list1 (cons data data_list1))
      )
      (setq n (1+ n))
    )
    (setq data_list2 (reverse dummy_list))
    (k_equal_auswahl)
    (k_equal_abwahl)
    (if	data_list2
      (progn
	(setq nr (min nr (1- (length data_list2))))
	(set_tile "abwahl" (itoa nr))
      )
    )
  )

  (defun k_equal_auswahl_s ()
    (mode_tile "rein" 1)
    (mode_tile "raus" 0)
    (if	(= $reason 4)
      (k_equal_raus)
    )
  )

  (defun k_equal_abwahl_s ()
    (mode_tile "rein" 0)
    (mode_tile "raus" 1)
    (if	(= $reason 4)
      (k_equal_rein)
    )
  )

  (defun k_equal_auswahl ()
    (setq auswahl_list (list))
    (foreach
	      data
		  (reverse data_list1)
      (setq art (nth 1 data))
      (setq wert (cdr (nth 2 data)))
      (cond
	((= (type wert) 'real)
	 (setq wert (rtos wert))
	)
	((= (type wert) 'int)
	 (setq wert (itoa wert))
	)
	((= (type wert) 'str)
	 (setq wert wert)
	)
	((= (type wert) 'list)
	 (setq dummy "")
	 (foreach
		   w
		    wert
	   (cond
	     ((= (type w) 'real)
	      (setq w (rtos w))
	     )
	     ((= (type w) 'int)
	      (setq w (itoa w))
	     )
	     ((= (type w) 'str)
	      (setq w w)
	     )
	   )
	   (setq dummy (strcat dummy "," w))
	 )
	 (setq wert (substr dummy 2))
	)
	((= (type wert) 'SYM)
	 (setq wert (vl-princ-to-string wert))
	)
      )
      (setq data (strcat art " = " wert))
      (setq auswahl_list (cons data auswahl_list))
    )
    (start_list "auswahl")
    (mapcar 'add_list auswahl_list)
    (end_list)
  )

  (defun k_equal_abwahl	()
    (setq abwahl_list (list))
    (foreach
	      data
		  (reverse data_list2)
      (setq art (nth 1 data))
      (setq wert (cdr (nth 2 data)))
      (cond
	((= (type wert) 'real)
	 (setq wert (rtos wert))
	)
	((= (type wert) 'int)
	 (setq wert (itoa wert))
	)
	((= (type wert) 'str)
	 (setq wert wert)
	)
	((= (type wert) 'list)
	 (setq dummy "")
	 (foreach
		   w
		    wert
	   (cond
	     ((= (type w) 'real)
	      (setq w (rtos w))
	     )
	     ((= (type w) 'int)
	      (setq w (itoa w))
	     )
	     ((= (type w) 'str)
	      (setq w w)
	     )
	   )
	   (setq dummy (strcat dummy "," w))
	 )
	 (setq wert (substr dummy 2))
	)
	((= (type wert) 'SYM)
	 (setq wert (vl-princ-to-string wert))
	)
      )
      (setq data (strcat art " = " wert))
      (setq abwahl_list (cons data abwahl_list))
    )
    (start_list "abwahl")
    (mapcar 'add_list abwahl_list)
    (end_list)
  )

  (defun k_equal_dialog	()
    (setq ent_data (entget ent_name))
    (setq obj_art (cdr (assoc 0 ent_data)))
    (setq data_list1 (list))

    (setq red	(vla-get-red
		  (vla-get-truecolor (vlax-ename->vla-object ent_name))
		)
	  green	(vla-get-green
		  (vla-get-truecolor (vlax-ename->vla-object ent_name))
		)
	  blue	(vla-get-blue
		  (vla-get-truecolor (vlax-ename->vla-object ent_name))
		)
    )

    (if	(assoc 420 ent_data)
      (progn
	(setq
	  farbnummer (cdr (assoc 420 ent_data))
	  bookname   (vla-get-bookname
		       (vla-get-truecolor
			 (vlax-ename->vla-object ent_name)
		       )
		     )
	  colorname  (vla-get-colorname
		       (vla-get-truecolor
			 (vlax-ename->vla-object ent_name)
		       )
		     )
	)
	(if (= bookname "")
	  (setq	color
		 (cons
		   6
		   (strcat
		     "RGB:"
		     (itoa
		       (vla-get-red
			 (vla-get-truecolor (vlax-ename->vla-object ent_name))
		       )
		     )
		     ","
		     (itoa
		       (vla-get-green
			 (vla-get-truecolor (vlax-ename->vla-object ent_name))
		       )
		     )
		     ","
		     (itoa
		       (vla-get-blue
			 (vla-get-truecolor (vlax-ename->vla-object ent_name))
		       )
		     )
		   )
		 )
	  )
	  (setq	color
		 (cons
		   6
		   (strcat
		     (vla-get-bookname
		       (vla-get-truecolor (vlax-ename->vla-object ent_name))
		     )
		     "$"
		     (vla-get-colorname
		       (vla-get-truecolor (vlax-ename->vla-object ent_name))
		     )
		   )
		 )
	  )
	)
	(setq farbfilter (list (assoc 420 ent_data)))
      )
      (progn
	(if (assoc 62 ent_data)
	  (setq color (assoc 62 ent_data))
	  (setq color (cons 62 256))
	)
	(setq farbfilter (list color))
      )
    )

    (if	(assoc 6 ent_data)
      (setq linientyp (assoc 6 ent_data))
      (setq linientyp (cons 6 "vonlayer"))
    )
    (setq data_list1 (list))
    (setq obj_name (k_->obj_name ent_name))

    (setq data_list2
	   (append
	     (list
	       (list
		 "vla"
		 "Rotwert"
		 (cons
		   "(vla-get-red (vla-get-truecolor (vlax-ename->vla-object ent_name)))"
		   (vla-get-red
		     (vla-get-truecolor
		       obj_name
		     )
		   )
		 )
	       )
	       (list
		 "vla"
		 "Grnwert"
		 (cons
		   "(vla-get-green (vla-get-truecolor (vlax-ename->vla-object ent_name)))"
		   (vla-get-green
		     (vla-get-truecolor
		       obj_name
		     )
		   )
		 )
	       )
	       (list
		 "vla"
		 "Blauwert"
		 (cons
		   "(vla-get-blue (vla-get-truecolor (vlax-ename->vla-object ent_name)))"
		   (vla-get-blue
		     (vla-get-truecolor
		       obj_name
		     )
		   )
		 )
	       )
	       (list
		 "vla"
		 "Farbbuchname"
		 (cons
		   "(vla-get-bookname (vla-get-truecolor (vlax-ename->vla-object ent_name)))"
		   (vla-get-bookname
		     (vla-get-truecolor
		       obj_name
		     )
		   )
		 )
	       )
	       (list
		 "vla"
		 "Farbname"
		 (cons
		   "(vla-get-colorname (vla-get-truecolor (vlax-ename->vla-object ent_name)))"
		   (vla-get-colorname
		     (vla-get-truecolor
		       obj_name
		     )
		   )
		 )
	       )
	       (list
		 "vla"
		 "Transparenz"
		 (cons
		   "(vla-get-EntityTransparency (vlax-ename->vla-object ent_name))"
		   (vla-get-EntityTransparency
		     obj_name
		   )
		 )
	       )
	       (list
		 "vla"
		 "Material"
		 (cons
		   "(vla-get-Material (vlax-ename->vla-object ent_name))"
		   (vla-get-Material
		     obj_name
		   )
		 )
	       )
	     )
	     (mapcar '(lambda (data)
			(if (= (nth 0 data) "ML-Beschreibung")
			  (list -3 (nth 0 data) (cons 1 (nth 1 data)))
			  (list -66 (nth 0 data) (cons 1 (nth 1 data)))
			)
		      )
		     (k_get_data
		       ent_name
		       "*"
		       app_name
		       nil
		     )
	     )
	     (list (list 410 "Layout" (assoc 410 ent_data)))
	   )
    )
    (if	(assoc 48 ent_data)
      (setq data_list2
	     (append
	       (list
		 (list 48 "Objektlinientypskalierung" (assoc 48 ent_data))
	       )
	       data_list2
	     )
      )
      (setq data_list2
	     (append
	       (list
		 (list 48 "Objektlinientypskalierung" '(48 . 1.0))
	       )
	       data_list2
	     )
      )
    )
    (if	(assoc 370 ent_data)
      (setq data_list2
	     (append
	       (list
		 (list 370 "Linienstrke" (assoc 370 ent_data))
	       )
	       data_list2
	     )
      )
      (setq data_list2
	     (append
	       (list
		 (list 370 "Linienstrke" '(370 . -1))
	       )
	       data_list2
	     )
      )
    )
    (cond
      ((= obj_art "3DFACE")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
	      )
       )

      )
      ((= obj_art "3DSOLID")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
	      )
       )
       (if (vl-catch-all-error-p
	     (setq SolidType
		    (vl-catch-all-apply
		      'vla-get-SolidType
		      (list obj_name)
		    )
	     )
	   )
	 nil
	 (setq data_list2
		(append
		  (list
		    (list
		      "vla"
		      "SolidType"
		      (cons
			"(vla-get-SolidType (vlax-ename->vla-object ent_name))"
			(vla-get-SolidType obj_name)
		      )
		    )
		  )
		  data_list2
		)
	 )
       )
       (setq data_list2
	      (append
		(list
		  (list
		    "vla"
		    "Volume"
		    (cons
		      "(vla-get-Volume (vlax-ename->vla-object ent_name))"
		      (vla-get-Volume obj_name)
		    )
		  )
		)
		data_list2
	      )
       )
      )
      ((= obj_art "ACAD_PROXY_ENTITY")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
	      )
       )
      )
      ((= obj_art "ACAD_TABLE")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list
		      "vla"
		      "Stilname"
		      (cons
			"(vla-get-StyleName (vlax-ename->vla-object ent_name))"
			(vla-get-stylename obj_name)
		      )
		    )
	      )
       )
      )
      ((= (substr obj_art 1 3) "AEC")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
	      )
       )
      )
      ((= obj_art "ARC")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
		    (list 40 "Radius" (assoc 40 ent_data))
	      )
       )
      )
      ((= obj_art "ATTDEF")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
		    (list 7 "Stilname" (assoc 7 ent_data))
	      )
       )
       (setq data_list2
	      (append
		(list (list 2 "Bezeichnung" (assoc 2 ent_data))
		      (list 3 "Eingabe" (assoc 3 ent_data))
		      (list 40 "Texthhe" (assoc 40 ent_data))
		)
		data_list2
	      )
       )
      )
      ((= obj_art "ATTRIB")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
	      )
       )
      )
      ((= obj_art "CIRCLE")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
		    (list 40 "Radius" (assoc 40 ent_data))
	      )
       )
      )
      ((= obj_art "DIMENSION")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
		    (list 3 "Bemaungsstil" (assoc 3 ent_data))
	      )
       )
       (setq data_list2
	      (append
		(list
		  (list
		    "vla"
		    "Bemaungsart"
		    (cons
		      "(vla-get-ObjectName (vlax-ename->vla-object ent_name))"
		      (vla-get-ObjectName
			obj_name
		      )
		    )
		  )
		)
		data_list2
	      )
       )
      )
      ((= obj_art "ELLIPSE")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
	      )
       )
      )
      ((= obj_art "HATCH")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
		    (list 2 "Schraffurmuster" (assoc 2 ent_data))
	      )
       )
       (if (assoc 41 ent_data)
	 (setq data_list1
		(reverse
		  (cons	(list 41 "Skalierung" (assoc 41 ent_data))
			(reverse data_list1)
		  )
		)
	 )
       )
       (if (assoc 52 ent_data)
	 (setq data_list2
		(append
		  (list
		    (list 52 "Schraffurwinkel" (assoc 52 ent_data))
		  )
		  data_list2
		)
	 )
       )
      )
      ((= obj_art "IMAGE")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
	      )
       )
      )
      ((= obj_art "INSERT")
       (setq data_list1
	      (list
		(list 0 "Objektart" (assoc 0 ent_data))
		(list 8 "Layer" (assoc 8 ent_data))
		(list 62 "Farbe" color)
		(list
		  "vla"
		  "Originalname"
		  (cons
		    "(vla-get-EffectiveName (vlax-ename->vla-object ent_name))"
		    (vla-get-effectivename obj_name)
		  )
		)
		(list
		  "vla"
		  "Dynamisch"
		  (cons
		    "(vla-get-IsDynamicBlock (vlax-ename->vla-object ent_name))"
		    (vla-get-IsDynamicBlock obj_name)
		  )
		)
	      )
       )
       (setq data_list2
	      (append
		(list (list 2 "Blockname" (assoc 2 ent_data))
		      (list 6 "Linientyp" linientyp)
		      (list 41 "X-Skalierfaktor" (assoc 41 ent_data))
		      (list 42 "Y-Skalierfaktor" (assoc 42 ent_data))
		      (list 43 "Z-Skalierfaktor" (assoc 43 ent_data))
		      (list 66 "Attribute vorhanden" (cons 66 1))
		      (list 50 "Drehwinkel" (assoc 50 ent_data))
		)
		data_list2
	      )
       )
      )
      ((= obj_art "LEADER")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 3 "Bemaungsstil" (assoc 3 ent_data))
	      )
       )
       (setq data_list2
	      (append
		(list (list 6 "Linientyp" linientyp))
		data_list2
	      )
       )
      )
      ((= obj_art "LINE")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
	      )
       )
       (setq data_list2
	      (append
		(list
		  (list
		    "vla"
		    "Lnge"
		    (cons
		      "(vla-get-length (vlax-ename->vla-object ent_name))"
		      (vla-get-length obj_name)
		    )
		  )
		)
		data_list2
	      )
       )
      )
      ((= obj_art "LWPOLYLINE")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
	      )
       )
       (setq data_list2
	      (append
		(list
		  (list
		    "vla"
		    "Geschlossen"
		    (cons
		      "(vla-get-closed (vlax-ename->vla-object ent_name))"
		      (vla-get-closed obj_name)
		    )
		  )
		)
		data_list2
	      )
       )
       (setq data_list2
	      (append
		(list
		  (list
		    "vla"
		    "Lnge"
		    (cons
		      "(vla-get-length (vlax-ename->vla-object ent_name))"
		      (vla-get-length obj_name)
		    )
		  )
		)
		data_list2
	      )
       )
       (if (assoc 43 ent_data)
	 (setq data_list2
		(append
		  (list
		    (list 43 "Globale Breite" (assoc 43 ent_data))
		  )
		  data_list2
		)
	 )
       )
      )
      ((= obj_art "MLINE")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
		    (list 2 "Stilname" (assoc 2 ent_data))
	      )
       )
       (setq data_list2
	      (append
		(list
		  (list 70 "ML-Ausrichtung" (assoc 70 ent_data))
		)
		data_list2
	      )
       )
      )
      ((= obj_art "MTEXT")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 7 "Stilname" (assoc 7 ent_data))
	      )
       )
       (setq data_list2
	      (append
		(list (list 1 "Textinhalt" (assoc 1 ent_data))
		      (list 6 "Linientyp" linientyp)
		      (list 40 "Texthhe" (assoc 40 ent_data))
		      (list 50 "Drehung" (assoc 50 ent_data))
		      (list 210 "Ausrichtung" (assoc 210 ent_data))
		)
		data_list2
	      )
       )
      )
      ((= obj_art "OLEFRAME")
      )
      ((= obj_art "OLE2FRAME")
      )
      ((= obj_art "POINT")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
	      )
       )
      )
      ((= obj_art "POLYLINE")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
	      )
       )
      )
      ((= obj_art "RAY")
      )
      ((= obj_art "REGION")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
	      )
       )
      )
      ((= obj_art "SEQEND")
      )
      ((= obj_art "SOLID")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
	      )
       )
      )
      ((= obj_art "SURFACE")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
	      )
       )
      )
      ((= obj_art "SYMBOL")
      )
      ((= obj_art "SPLINE")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
		    (list
		      "vla"
		      "geschlossen"
		      (cons
			"(vla-get-Closed (vlax-ename->vla-object ent_name))"
			(vla-get-closed obj_name)
		      )
		    )
	      )
       )
       (setq data_list2
	      (append
		(list
		  (list
		    "vla"
		    "Lnge"
		    (cons
		      "(VLAX-CURVE-GETENDPARAM (vlax-ename->vla-object ent_name))"
		      (VLAX-CURVE-GETENDPARAM obj_name)
		    )
		  )
		)
		data_list2
	      )
       )
      )
      ((= obj_art "TEXT")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 7 "Stilname" (assoc 7 ent_data))
	      )
       )
       (setq data_list2
	      (append
		(list (list 1 "Textinhalt" (assoc 1 ent_data))
		      (list 6 "Linientyp" linientyp)
		      (list 40 "Texthhe" (assoc 40 ent_data))
		      (list 50 "Drehung" (assoc 50 ent_data))
		      (list 210 "Ausrichtung" (assoc 210 ent_data))
		)
		data_list2
	      )
       )
       (if (assoc 41 ent_data)
	 (setq data_list2
		(append
		  data_list2
		  (list
		    (list 41 "Breitenfaktor" (assoc 41 ent_data))
		  )
		)
	 )
	 (setq data_list2
		(append	data_list2
			(list
			  (list 41 "Breitenfaktor" (cons 41 1.0))
			)
		)
	 )
       )
      )
      ((= obj_art "TRACE")
      )
      ((= obj_art "VIEWPORT")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
		    (list 410 "Layout" (assoc 410 ent_data))
	      )
       )
       (setq data_list2
	      (append data_list2
		      (list
			(list 68 "Aktiv" (assoc 68 ent_data))
		      )
	      )
       )
      )
      ((= obj_art "WIPEOUT")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
	      )
       )
      )
      ((= obj_art "XLINE")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
	      )
       )
      )
      ((= obj_art "MANSFEN")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
	      )
       )
      )
      ((= obj_art "ACAD_PROXY_ELEMENT")
       (setq data_list1
	      (list (list 0 "Objektart" (assoc 0 ent_data))
		    (list 8 "Layer" (assoc 8 ent_data))
		    (list 62 "Farbe" color)
		    (list 6 "Linientyp" linientyp)
	      )
       )
      )
    )

;;;    (print data_list1)
;;;    (print data_list2)

    (setq k_equal_id (load_dialog "k_equal.dcl"))
    (if	(not (new_dialog "k_equal" k_equal_id))
      (exit)
    )
    (k_equal_auswahl)
    (k_equal_abwahl)
    (action_tile "auswahl" "(k_equal_auswahl_s)")
    (action_tile "abwahl" "(k_equal_abwahl_s)")
    (action_tile "raus" "(k_equal_raus)")
    (action_tile "rein" "(k_equal_rein)")
    (action_tile "accept" "(end_k_equal 1)")
    (action_tile "cancel" "(end_k_equal 0)")
    (set_tile "auswahl" "0")
    (k_equal_auswahl_s)
    (start_dialog)
    (unload_dialog k_equal_id)
  )

  (print)
  (setq app_name "*")
  (if (k_get_merkliste "k_equal_data")
    (while (not	(or (setq ent_name
			   (car
			     (entsel "Objekt whlen oder ENTER fr letzten Filter")
			   )
		    )
		    (k_get_merkliste "k_equal_data")
		)
	   )
    )
    (while (not	(setq ent_name
		       (car
			 (entsel "Objekt whlen ")
		       )
		)
	   )
    )
  )
  (if ent_name
    (k_equal_dialog)
    (setq data_list1
	   (k_get_merkliste "k_equal_data")
	  farbfilter
	   (k_get_merkliste "k_equal_color")
	  ok 1
    )
  )

  (if (= ok 1)
    (progn
      (k_put_merkliste "k_equal_data" data_list1)
      (k_put_merkliste "k_equal_color" farbfilter)
;;; Auswahlfilter der "normalen" Obkektdaten
      (setq filter
	     (mapcar '(lambda (data) (nth 2 data))
		     (vl-remove-if
		       '(lambda	(data)
			  (or (= (car data) "vla")
			      (= (car data) -66)
			      (= (car data) 62)
			      (= (car data) -3)
			  )
			)
		       data_list1
		     )
	     )
      )

      (setq filter (mapcar '(lambda (dummy)
			      (if (= (strcase (vl-princ-to-string (cdr dummy))) "VONLAYER")
				(cons (car dummy) "BYLAYER")
				dummy
			      )
			    )
			   filter
		   )
      )

      (if (assoc 62 data_list1)
	(setq filter (append filter farbfilter))
      )

      (print "bei ENTER werden alle Objekte gewhlt")
      (if (null (setq satz (ssget filter)))
	(setq satz (ssget "_x" filter))
      )
      (setq ent_list (k_satz->entlist satz))
;;; Filterung der Farbe
      (if (assoc 62 data_list1)
	(if (= (caar farbfilter) 62)
	  (setq	ent_list
		 (vl-remove-if
		   '(lambda (ent_name)
		      (assoc 420 (entget ent_name))
		    )
		   ent_list
		 )
	  )
	  (setq	ent_list
		 (vl-remove-if-not
		   '(lambda (tc)
		      (setq tc (vla-get-truecolor (k_->obj_name ent_name)))
		      (and
			(= bookname (vla-get-bookname tc))
			(= colorname (vla-get-colorname tc))
			(= red (vla-get-red tc))
			(= green (vla-get-green tc))
			(= blue (vla-get-blue tc))
		      )
		    )
		   ent_list
		 )
	  )
	)
      )
;;; Filterung Multilinienbeschreibung
      (if (setq ML-Beschreibung (cdr (caddr (assoc -3 data_list1))))
	(setq ent_list
	       (vl-remove-if-not
		 '(lambda (obj_name)
		    (and
		      (= (vla-get-ObjectName obj_name) "AcDbMline")
		      (= ML-Beschreibung
			 (cdr
			   (assoc 3
				  (dictsearch
				    (cdr
				      (assoc -1 (dictsearch (namedobjdict) "ACAD_MLINESTYLE"))
				    )
				    (vla-get-StyleName obj_name)
				  )
			   )
			 )
		      )
		    )
		  )
		 (mapcar 'k_->obj_name ent_list)
	       )
	)
      )
;;; Filterung von Eigenschaften ber vla-get-...
      (if (setq	vla_filter_list
		 (mapcar '(lambda (data) (nth 2 data))
			 (vl-remove-if-not
			   '(lambda (data) (= (car data) "vla"))
			   data_list1
			 )
		 )
	  )
	(setq ent_list
	       (vl-remove-if-not
		 '(lambda (ent_name)
		    (vl-every
		      'k_is
		      (mapcar
			'(lambda (vla_filter)
			   (equal
			     (vl-catch-all-apply
			       (car (read (car vla_filter)))
			       (list (eval (cadr (read (car vla_filter)))))
			     )
			     (cdr vla_filter)
			   )
			 )
			vla_filter_list
		      )
		    )
		  )
		 ent_list
	       )
	)
      )
;;; Filterung Attribute und dynamische Parameter
      (if (setq	att_filter_list
		 (mapcar '(lambda (data) (list (nth 1 data) (cdr (nth 2 data))))
			 (vl-remove-if-not
			   '(lambda (data) (= (car data) -66))
			   data_list1
			 )
		 )
	  )
	(progn
	  (setq	att_bez_list
		 (mapcar '(lambda (data) (nth 0 data))
			 att_filter_list
		 )
	  )
	  (setq	att_inh_list
		 (mapcar '(lambda (data) (nth 1 data))
			 att_filter_list
		 )
	  )
	  (setq n (length ent_list))
	  (k_counter_dialog
	    "start"
	    "zu filternde Objekte"
	    "Attribute und dynamische Parameter"
	  )
	  (setq	ent_list
		 (vl-remove-if-not
		   '(lambda (ent_name)
		      (k_counter_dialog
			"show"
			(setq n (1- n))
			nil
		      )
		      (equal (mapcar 'cadr
				     (k_get_data
				       ent_name
				       att_bez_list
				       app_name
				       nil
				     )
			     )
			     att_inh_list
		      )
		    )
		   ent_list
		 )
	  )
	  (k_counter_dialog "end" nil nil)
	)
      )
;;; verknpfte Objekte
      (if (= assoc_objects "1")
	(setq ent_list
	       (apply
		 'append
		 (mapcar
		   '(lambda (ent_name)
		      (setq ent_data (entget ent_name))
		      (cons
			ent_name
			(vl-remove-if
			  '(lambda (e_name)
			     (member (cdr (assoc 0 (entget e_name)))
				     '("BLOCK_RECORD"
				      )
			     )
			   )
			  (mapcar 'cdr
				  (k_get_assoc ent_data '(330 340))
			  )
			)
		      )
		    )
		   ent_list
		 )
	       )
	)
      )
      (k_put_merkliste "ent_list" ent_list)
      (setq satz (k_entlist->satz ent_list))
      (command "_select" satz "")
      (sssetfirst satz satz)
    )
  )
  (princ)
)
;;; - ------------------------------------------------------------------------------ - ;
(princ
  (strcat
    "\nk_equal:  Objekte mit gleichen Daten finden"
    "\n===========  "
    "\n(C) Andreas Kraus 2023 (info@kraus-cad.de)"
    "\nBefehlszeilenaufruf : k_equal\n"
  )
)
;;; - ------------------------------------------------------------------------------ - ;
(princ)